--[[---------------------------------------------------------------------------
	Chocolatier Two Recipe Book
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local type = gRecipeSelection.type
assert(type)

local recipe_instructions = "recipe_instructions"
if gCurrentFactory then recipe_instructions = "recipe_factory" end

-------------------------------------------------------------------------------

local function SelectRecipe(item)
	EnableWindow(gRecipeSelection.name, true)
	EnableWindow(gRecipeSelection.name.."_select", false)
	gRecipeSelection = item
	EnableWindow(gRecipeSelection.name, false)
	EnableWindow(gRecipeSelection.name.."_select", true)
	EnableWindow("select_recipe", item.known or false)
	UpdateDynamicContent("recipe_recipe")
end

-------------------------------------------------------------------------------

local machineSize = 125

local rowCount = 3
local perRow = 4

local dx = (ui.rbWidth - perRow * ui.itemWidth) / (perRow + 1)
local xLeft = (ui.rbWidth - perRow * dx - machineSize) / 2 + machineSize

--local dy = (ui.rbHeight - rowCount * ui.itemHeight) / (rowCount + 3)
local dy = 40
local yTop = (ui.rbHeight - rowCount * dy) / 2

local machineY = yTop - 5

local x = xLeft
local y = yTop

local count = 0
local recipes = {}
for _,p in ipairs(type.products) do
	local i = p
	
	-- highlights below unmade recipes in story mode
	if gSim.mode == "story" and p.known and (p.sold > 0 or p.inventory > 0) then
		table.insert(recipes, Bitmap { x=x-4,y=y-3, image="item/highlight_"..type.name })
	end
	
	local bitmaps = { Bitmap { image="item/"..i.name, name=i.name } }
	
	-- overlays on unknown recipes
	if not p.known then
		if p.lab then
			bitmaps = { Bitmap { image="item/unknown", name=i.name } }
		else
			table.insert(bitmaps, Bitmap { image="image/unknown_recipe_overlay" })
		end
	end

	-- sparkle on newly acquired recipes
	if p.newrecipe then
		table.insert(bitmaps, Sprite { x=16,y=16, image="glitz/sparkle.xml" })
		p.newrecipe = nil
	end

	if p.known or (not p.lab) then
		table.insert(recipes,
			Bitmap { x=x-12,y=y-12, image="item/"..i.name.."_big", name=i.name.."_select", scale=.875 })
	else
		table.insert(recipes,
			Bitmap { x=x-12,y=y-12, image="item/unknown_big", name=i.name.."_select", scale=.875 })
	end

	table.insert(recipes,
		Rollover { x=x,y=y, contents=i:RolloverTarget(),
			Group(bitmaps),
			command = function() PlaySound("ui_click") SelectRecipe(i) end,
		 })
	
	x = x + dx
	count = count + 1
	if count == perRow then
		count = 0
		x = xLeft
		y = y + dy
	end
end

-------------------------------------------------------------------------------

MakeDialog
{
	AppendStyle { font=recipeFont },
	
	Bitmap { x=0,y=machineY, image="image/machine_"..type.name.."_linestyle", scale=machineSize/ui.machineSize },

	Text { x=0,y=5,w=ui.rbWidth,h=30, label=LabelString(type.name), flags=kVAlignTop+kHAlignCenter, font=recipeTitleFont },
	Text { x=0,y=30,w=ui.rbWidth,h=yTop-30, label=LabelString(type.name.."_intro") },
	Text { x=0,y=165,w=ui.rbWidth,h=150, label=LabelString(recipe_instructions) },
	
	Group(recipes),
	AnimationWindow { fps=20, x=0,y=0,w=1,h=1 },
}

for _,p in ipairs(type.products) do
	EnableWindow(p.name .. "_select", false)
end
SelectRecipe(gRecipeSelection)
